﻿using System;
using System.ComponentModel;
using System.Linq.Expressions;

namespace Azyobuzi.Twikoto2
{
    /// <summary>
    /// Livet次バージョンまでの応急処置
    /// </summary>
    public class MyNotifyObject : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;

        protected void RaisePropertyChanged<T>(Expression<Func<T>> propertyExpression)
        {
            if (propertyExpression.Body is MemberExpression)
            {
                var memberExpression = (MemberExpression)propertyExpression.Body;
                RaisePropertyChanged(memberExpression.Member.Name);
            }
            else
            {
                throw new ArgumentException("このメソッドでは ()=>プロパティ の形式のラムダ式以外許可されません");
            }
        }

        protected void RaisePropertyChanged(string propertyName)
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
        }
    }
}
